/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.constants.JobType;
import noppes.npcs.api.entity.data.role.IJobBard;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;

public class JobBard
extends JobInterface
implements IJobBard {
    private volatile transient WeakReference<Boolean> cachedInRange = new WeakReference<Boolean>(false);
    private volatile transient long checkTime = 0L;
    public boolean hasOffRange = true;
    public boolean isStreamer = true;
    public boolean isRange = true;
    public int[] range = new int[]{2, 64};
    public int[] minPos = new int[]{2, 2, 2};
    public int[] maxPos = new int[]{64, 64, 64};
    public String song = "";

    public JobBard(EntityNPCInterface npc) {
        super(npc);
        this.type = JobType.BARD;
    }

    @Override
    public void delete() {
    }

    private int getIntInByte(byte b) {
        return (b <= 0 ? 256 : 0) + b;
    }

    @Override
    public String getSong() {
        return this.song;
    }

    @Override
    public void killed() {
        if (this.npc.field_70170_p.field_72995_K && this.isStreamer && this.hasOffRange && MusicController.Instance.isPlaying(this.song)) {
            MusicController.Instance.stopSound(this.song, this.isStreamer ? SoundCategory.AMBIENT : SoundCategory.MUSIC);
        }
    }

    @Override
    public boolean isWorking() {
        if (this.npc.func_70613_aW() || this.song.isEmpty()) {
            return false;
        }
        MusicController mData = MusicController.Instance;
        return this.npc.equals((Object)mData.musicBard) || this.npc.equals((Object)mData.songBard);
    }

    public void onLivingUpdate() {
        if (this.npc.func_70613_aW() || this.song.isEmpty()) {
            return;
        }
        MusicController mData = MusicController.Instance;
        if (this.isStreamer ? mData.unloadSongBard : mData.unloadMusicBard) {
            EntityNPCInterface oldNPC;
            EntityNPCInterface entityNPCInterface = oldNPC = this.isStreamer ? mData.songBard : mData.musicBard;
            if (oldNPC == null) {
                if (this.isStreamer) {
                    mData.unloadSongBard = false;
                } else {
                    mData.unloadMusicBard = false;
                }
            } else if (oldNPC.func_110124_au().equals(this.npc.func_110124_au())) {
                if (this.isStreamer) {
                    mData.unloadSongBard = false;
                    mData.songBard = this.npc;
                } else {
                    mData.musicBard = this.npc;
                    mData.unloadMusicBard = false;
                }
            }
        }
        if (!mData.isBardPlaying(this.song, this.isStreamer)) {
            if (!this.getPlayerInRange()) {
                return;
            }
            mData.bardPlaySound(this.song, this.isStreamer, this.npc);
        } else if (this.npc.equals((Object)(this.isStreamer ? mData.songBard : mData.musicBard)) && !this.song.equals(this.isStreamer ? mData.song : mData.music)) {
            if (!mData.song.isEmpty() && this.npc.equals((Object)mData.songBard)) {
                mData.stopSound(mData.song, SoundCategory.AMBIENT);
            }
            if (!mData.music.isEmpty() && this.npc.equals((Object)mData.musicBard)) {
                mData.stopSound(mData.music, SoundCategory.MUSIC);
            }
        } else if (!this.npc.equals((Object)(this.isStreamer ? mData.songBard : mData.musicBard))) {
            EntityNPCInterface oldNPC;
            EntityPlayer player = CustomNpcs.proxy.getPlayer();
            if (player == null) {
                return;
            }
            EntityNPCInterface entityNPCInterface = oldNPC = this.isStreamer ? mData.songBard : mData.musicBard;
            if ((oldNPC == null || this.npc.func_70032_d((Entity)player) < oldNPC.func_70032_d((Entity)player)) && this.getPlayerInRange()) {
                String mSong;
                String string = mSong = this.isStreamer ? mData.song : mData.music;
                if (mSong.equals(this.song)) {
                    if (this.isStreamer) {
                        mData.songBard = this.npc;
                        mData.music = "";
                        mData.musicBard = null;
                    } else {
                        mData.song = "";
                        mData.songBard = null;
                        mData.musicBard = this.npc;
                    }
                    mData.setNewPosSong(mSong, (float)this.npc.field_70165_t, (float)this.npc.field_70163_u, (float)this.npc.field_70161_v);
                } else {
                    mData.stopSound(mSong, this.isStreamer ? SoundCategory.AMBIENT : SoundCategory.MUSIC);
                    mData.bardPlaySound(this.song, this.isStreamer, this.npc);
                }
            }
        } else if (this.hasOffRange && this.npc.equals((Object)(this.isStreamer ? mData.songBard : mData.musicBard)) && !this.getPlayerInRange()) {
            mData.stopSound(this.song, this.isStreamer ? SoundCategory.AMBIENT : SoundCategory.MUSIC);
        }
    }

    private boolean getPlayerInRange() {
        EntityPlayer player = CustomNpcs.proxy.getPlayer();
        if (player == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now < this.checkTime) {
            return Boolean.TRUE.equals(this.cachedInRange.get());
        }
        AxisAlignedBB aabb = this.npc.func_174813_aQ();
        aabb = this.isRange ? aabb.func_72314_b((double)this.range[0], (double)this.range[0], (double)this.range[0]) : new AxisAlignedBB(aabb.field_72340_a - (double)this.minPos[0], aabb.field_72338_b - (double)this.minPos[1], aabb.field_72339_c - (double)this.minPos[2], aabb.field_72336_d + (double)this.minPos[0], aabb.field_72337_e + (double)this.minPos[1], aabb.field_72334_f + (double)this.minPos[2]);
        List list = new ArrayList();
        try {
            list = this.npc.field_70170_p.func_72872_a(EntityPlayer.class, aabb);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean result = list.contains(CustomNpcs.proxy.getPlayer());
        this.cachedInRange = new WeakReference<Boolean>(result);
        this.checkTime = now + 500L;
        return result;
    }

    @Override
    public void load(NBTTagCompound compound) {
        super.load(compound);
        this.type = JobType.BARD;
        this.song = compound.func_74779_i("BardSong");
        this.isStreamer = compound.func_74767_n("BardStreamer");
        this.hasOffRange = compound.func_74767_n("BardHasOff");
        if (compound.func_150297_b("BardRangeData", 7) && compound.func_150297_b("BardIsRange", 1)) {
            this.isRange = compound.func_74767_n("BardIsRange");
            byte[] data = compound.func_74770_j("BardRangeData");
            if (data.length > 1) {
                this.range = new int[]{this.getIntInByte(data[0]), this.getIntInByte(data[1])};
            }
            if (data.length > 4) {
                this.minPos = new int[]{this.getIntInByte(data[2]), this.getIntInByte(data[3]), this.getIntInByte(data[4])};
            } else {
                this.maxPos = new int[]{this.range[0], this.range[0], this.range[0]};
            }
            this.maxPos = data.length > 7 ? new int[]{this.getIntInByte(data[5]), this.getIntInByte(data[6]), this.getIntInByte(data[7])} : new int[]{this.range[1], this.range[1], this.range[1]};
        } else if (compound.func_150297_b("BardMinRange", 3) && compound.func_150297_b("BardMaxRange", 3)) {
            this.range = new int[]{compound.func_74762_e("BardMinRange"), compound.func_74762_e("BardMaxRange")};
            this.isRange = true;
            this.minPos = new int[]{this.range[0], this.range[0], this.range[0]};
            this.maxPos = new int[]{this.range[1], this.range[1], this.range[1]};
        }
    }

    @Override
    public void setSong(String newSong) {
        this.song = newSong;
        this.npc.updateClient = true;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound compound) {
        super.save(compound);
        compound.func_74778_a("BardSong", this.song);
        compound.func_74757_a("BardStreamer", this.isStreamer);
        compound.func_74757_a("BardHasOff", this.hasOffRange);
        compound.func_74757_a("BardIsRange", this.isRange);
        compound.func_74773_a("BardRangeData", new byte[]{(byte)this.range[0], (byte)this.range[1], (byte)this.minPos[0], (byte)this.minPos[1], (byte)this.minPos[2], (byte)this.maxPos[0], (byte)this.maxPos[1], (byte)this.maxPos[2]});
        return compound;
    }
}

